--> Pralable
/*
IF EXISTS(SELECT NULL FROM sys.databases WHERE name = 'DB_CRYPT')
BEGIN
   EXEC ('USE DB_CRYPT;
          ALTER DATABASE DB_CRYPT SET SINGLE_USER WITH ROLLBACK IMMEDIATE;
          USE master;
          DROP DATABASE DB_CRYPT;');
END;

IF EXISTS(SELECT NULL FROM sys.databases WHERE name = 'DB_CLEAR')
BEGIN
   EXEC ('USE DB_CLEAR;
          ALTER DATABASE DB_CLEAR SET SINGLE_USER WITH ROLLBACK IMMEDIATE;
          USE master;
          DROP DATABASE DB_CLEAR;');
END;

IF EXISTS(SELECT * FROM sys.server_principals WHERE name = 'CNX_FRED')
   EXEC ('DROP LOGIN CNX_FRED;');

*/
-- USE master;

-- On cre une nouvelle base de donnes
CREATE DATABASE DB_CRYPT
GO

-- On se place dans le contexte de cette nouvelle base
USE DB_CRYPT
GO

-- On cre une table des patients
CREATE TABLE dbo.T_PATIENT_PTT
(PTT_ID               INT IDENTITY PRIMARY KEY,
 PTT_NOM_CRYPTE       VARBINARY(256), 
 PTT_NUMSECU_CRYPTE   VARBINARY(128));
GO
-- On insre une ligne avec les donnes cryptes dans la table
INSERT INTO dbo.T_PATIENT_PTT
VALUES (ENCRYPTBYPASSPHRASE('P@ss4u', 'Dupont'),
        ENCRYPTBYPASSPHRASE('P@ss4u', '1800675112337'));
GO

-- On cre une autre base de donnes
CREATE DATABASE DB_CLEAR
GO

USE DB_CLEAR
GO

-- On cre une procdure renvoyant les donnes dcryptes de la table
CREATE PROCEDURE dbo.P_PATIENT_PTT 
AS
SET NOCOUNT ON;
SELECT PTT_ID,
       CAST(DECRYPTBYPASSPHRASE('P@ss4u', PTT_NOM_CRYPTE) AS VARCHAR(32)) AS PTT_NOM_CLEAR,
       CAST(DECRYPTBYPASSPHRASE('P@ss4u', PTT_NUMSECU_CRYPTE) AS CHAR(13)) AS PTT_NUMSECU_CLEAR
FROM   DB_CRYPT.dbo.T_PATIENT_PTT
GO

-- On cre le compte de connexion pour Fred
CREATE LOGIN CNX_FRED 
   WITH PASSWORD = 'PassFred',
   DEFAULT_DATABASE = DB_CRYPT;
GO

-- On cre un utilisateur reli au compte de connexion de Fred
CREATE USER USR_FRED 
   FROM LOGIN CNX_FRED;
GO

-- On octroie le privilge dexcuter cette procdure  lutilisateur Fred
GRANT EXECUTE ON dbo.P_PATIENT_PTT TO USR_FRED;
GO

-- On se fait passer pour lutilisateur Fred
EXECUTE AS USER = 'USR_FRED';
-- afin de tester lexcution de la procdure
EXECUTE dbo.P_PATIENT_PTT;

REVERT;